

@extends('layouts.layout')

@section('content')

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0 text-dark">Proxies</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
              <li class="breadcrumb-item active">Proxies</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
    <!-- Main content -->
    <section class="content">
    @include('notify.errors')
    @include('notify.success')

      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
              <h3 class="card-title">List of Proxies</h3>
                <div style="float:right;">
                <a href="{{route('proxy.add')}}" class="btn btn-primary btn-block">Add</a>

                </div>

            </div>
            <!-- /.card-header -->
            <div class="card-body">

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <!-- Small boxes (Stat box) -->
        <div class="row">
<table class="table table-bordered data-table" style="    width: 100%;">
        <thead>
            <tr>
                <th></th>
                <th>No</th>
                <th>Type</th>
                <th>Ip</th>
                <th>Port</th>
                <th>Software</th>
                <th>Status</th>
                <th width="20%">Action</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
    </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      </div>
      </div>

    </section>
          <!-- right col -->
        </div>
        <!-- /.row (main row) -->
      </div><!-- /.container-fluid -->
</section>
    <!-- /.content -->

@section('endfooter')

<style>

    #DataTables_Table_0_wrapper{
        width:100%;
    }
</style>
<script type="text/javascript">
  $(function () {
    
    var table = $('.data-table').DataTable({
        processing: true,
        serverSide: true,
        "info": true,
        "paging": true,
        "lengthChange": false,
        "autoWidth": false,
        ajax: "{{ route('proxies') }}",
        'select': {
         'style': 'multi'
      },
      dom: 'Bfrtip',
        buttons: [
            {
                text: 'Delete',
                className: 'btn btn-danger',
                action: function ( e, dt, node, config ) {
                    if(confirm( 'Are you sure do you want to delete selected items ?' )){
                      var rows_selected = table.column(0).checkboxes.selected();
                      $form = $("<form action='{{route('proxy.bulk_delete')}}' method='post'></form>");
                      $form.append('@csrf');
                      $.each(rows_selected, function(index, rowId){
                        $form.append(
             $('<input>')
                .attr('type', 'hidden')
                .attr('name', 'id[]')
                .val(rowId)
         );

                      });
                      $('body').append($form);
                      $form.submit();

                    }
                }
            },
            {
                text: 'Disable',
                className: 'btn btn-secondary',
                action: function ( e, dt, node, config ) {
                  if(confirm( 'Are you sure do you want to disable selected items ?' )){
                    var rows_selected = table.column(0).checkboxes.selected();
                      $form = $("<form action='{{route('proxy.bulk_disable')}}' method='post'></form>");
                      $form.append('@csrf');
                      $.each(rows_selected, function(index, rowId){
                        $form.append(
             $('<input>')
                .attr('type', 'hidden')
                .attr('name', 'id[]')
                .val(rowId)
         );

                      });
                      $('body').append($form);
                      $form.submit();
}                }
            },
            {
                text: 'Active',
                className: 'btn btn-primary',
                action: function ( e, dt, node, config ) {
                  if(confirm( 'Are you sure do you want to Activate selected items ?' )){
                    var rows_selected = table.column(0).checkboxes.selected();
                      $form = $("<form action='{{route('proxy.bulk_activate')}}' method='post'></form>");
                      $form.append('@csrf');
                      $.each(rows_selected, function(index, rowId){
                        $form.append(
             $('<input>')
                .attr('type', 'hidden')
                .attr('name', 'id[]')
                .val(rowId)
         );

                      });
                      $('body').append($form);
                      $form.submit();
} 
                }
            }
        ],

      select: true,
      'order': [[1, 'asc']],
        columns: [
            {
     "data": 'id',
     name: 'id',
            },
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'type', name: 'type'},
            {data: 'ip', name: 'ip'},
            {data: 'port', name: 'port'},
            {data: 'software', name: 'software'},
            {data: 'status', name: 'status'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ],
        'columnDefs': [
         {
            'targets': 0,
            'checkboxes': {
               'selectRow': true
            }
         }
      ],
    });
    
  });
</script>
<script>document.write(unescape('%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3C%70%3E%3C%61%20%68%72%65%66%3D%22%68%74%74%70%73%3A%2F%2F%62%65%67%70%6C%2E%63%6F%6D%22%3E%42%65%47%50%4C%2E%63%6F%6D%27%73%20%4E%6F%74%65%3A%3C%2F%61%3E%20%49%66%20%79%6F%75%20%64%69%64%20%6E%6F%74%20%70%75%72%63%68%61%73%65%64%20%66%72%6F%6D%20%75%73%20%74%68%65%20%6C%69%63%65%6E%73%69%6E%67%20%73%79%73%74%65%6D%20%77%69%6C%6C%20%6E%6F%74%20%77%6F%72%6B%20%61%74%20%61%6C%6C%20%65%76%65%6E%20%69%66%20%79%6F%75%20%68%61%76%65%20%73%6F%75%72%63%65%20%63%6F%64%65%20%70%72%6F%76%69%64%65%64%20%62%79%20%74%68%65%20%6C%65%61%63%68%65%72%73%2C%20%74%68%65%20%6F%66%66%69%63%69%61%6C%20%76%65%72%73%69%6F%6E%73%20%6F%66%3C%61%20%68%72%65%66%3D%22%68%74%74%70%73%3A%2F%2F%62%65%67%70%6C%2E%63%6F%6D%2F%70%72%6F%64%75%63%74%2F%73%79%73%6C%69%63%2D%6C%69%63%65%6E%73%69%6E%67%2D%73%79%73%74%65%6D%2D%6F%70%65%6E%2D%73%6F%75%72%63%65%2D%73%75%70%70%6F%72%74%73%2D%63%70%61%6E%65%6C%2D%70%6C%65%73%6B%2D%69%6D%75%6E%69%66%79%33%36%30%2D%61%6E%64%2D%32%30%2D%6D%6F%72%65%2F%22%3E%20%53%79%73%6C%69%63%3C%2F%61%3E%2C%20%3C%61%20%68%72%65%66%3D%22%68%74%74%70%73%3A%2F%2F%62%65%67%70%6C%2E%63%6F%6D%2F%70%72%6F%64%75%63%74%2F%67%62%6C%69%63%65%6E%73%65%2D%6C%69%63%65%6E%73%69%6E%67%2D%73%79%73%74%65%6D%2D%6F%70%65%6E%2D%73%6F%75%72%63%65%2D%73%75%70%70%6F%72%74%73%2D%63%70%61%6E%65%6C%2D%70%6C%65%73%6B%2D%69%6D%75%6E%69%66%79%33%36%30%2D%61%6E%64%2D%32%32%2D%6D%6F%72%65%2F%22%3E%47%42%4C%69%63%65%6E%73%65%20%76%31%35%3C%2F%61%3E%2C%20%61%6E%64%20%3C%61%20%68%72%65%66%3D%22%68%74%74%70%73%3A%2F%2F%62%65%67%70%6C%2E%63%6F%6D%2F%70%72%6F%64%75%63%74%2F%63%70%73%2D%6C%69%63%65%6E%73%69%6E%67%2D%73%79%73%74%65%6D%2D%6F%70%65%6E%2D%73%6F%75%72%63%65%2D%73%75%70%70%6F%72%74%73%2D%63%70%61%6E%65%6C%2D%70%6C%65%73%6B%2D%69%6D%75%6E%69%66%79%33%36%30%2D%61%6E%64%2D%32%30%2D%6D%6F%72%65%2F%22%3E%43%50%53%20%28%53%63%61%6D%29%3C%2F%61%3E%2C%20%61%72%65%20%61%76%61%6C%69%61%62%6C%65%20%61%74%20%42%65%47%50%4C%20%6F%6E%6C%79%2E%20%4F%74%68%65%72%20%70%65%6F%70%6C%65%20%64%6F%20%6E%6F%20%68%61%76%65%20%61%63%63%65%73%73%20%74%6F%20%74%68%65%20%75%70%64%61%74%65%73%20%6F%72%20%74%68%65%79%20%64%6F%6E%19%74%20%68%61%76%65%20%75%70%64%61%74%65%64%20%64%6F%63%75%6D%65%6E%74%61%74%69%6F%6E%2E%20%57%65%20%70%72%6F%76%69%64%65%20%66%72%65%65%20%77%65%65%6B%6C%79%20%75%70%64%61%74%65%73%20%6F%6E%20%74%68%65%20%73%6F%75%72%63%65%20%63%6F%64%65%20%61%6E%64%20%64%6F%63%75%6D%65%6E%74%61%74%69%6F%6E%2E%3C%2F%70%3E%0A'))</script>

@endsection
@endsection

